*******************************************************************************
*                          680xx Grundprogramm sys                            *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                             System Routinen                                 *
*******************************************************************************


system:                         * Wichtige System Informationen
 move.l d1,-(a7)
 moveq #cpu,d0                  * Bit 0-2 : CPU
 move.b ioflag(a5),d1
 and.b #1,d1
 lsl.b #3,d1
 add.b d1,d0                    * Bit 3   : GDP;  Bit 4   : Keine Bedeutung mehr
 move.b uhrausw(a5),d1
 lsl.b #5,d1
 add.b d1,d0                    * Bit 5-6 : Uhrenkonfiguration
 move.b tracflag(a5),d1
 and.b #%10000,d1
 lsl.b #7-4,d1
 add.b d1,d0                    * Bit 7   : Trace aus/an
 tst.b cotempo(a5)
 beq.s system1
 add #$0100,d0                  * Bit 8   : Hardscroll bei co aus/an
system1:
 move.b menflag(a5),d1
 and #1,d1
 ror #7,d1
 or d1,d0                       * Bit 9   : Keine Bedeutung mehr
 move.b menflag(a5),d1
 and #%01000000,d1
 lsl #4,d1
 or d1,d0                       * Bit 10  : Hardcopy ber CI aus/an
 move.b serflag(a5),d1
 and #%1111,d1
 ror #5,d1                      * Bit 11-14 : Umlenkung auf SER
 or d1,d0
 move.b keydil(a5),d1
 and #%10000,d1
 ror #5,d1
 or d1,d0                       * Bit 15 : SCSI-Disk
 move.b ioflag(a5),d1
 lsr.b #1,d1
 and.w #%111,d1
 swap d1
 clr d1
 or.l d1,d0                     * Bit 16 : Key3, Bit 17 : SER, Bit 18 : SER2
 move.b keydil(a5),d1
 and #%100000,d1
 ror #2,d1
 swap d1
 clr d1
 or.l d1,d0                     * Bit 19 : IDE-Disk
 tst srdcap(a5)
 beq.s system2
 bset.l #20, d0                 * Bit 20 : SRAMDISK
system2:
 btst.b #6, keydil(a5)
 beq.s system3
 bset.l #21, d0                 * Bit 21 : GDP-FPGA
system3:
 tst.b gdpcol(a5)
 beq.s system4
 bset.l #22, d0                 * Bit 22 : Farbvariante der GDP-FPGA
system4:
 move.l (a7)+,d1
rts

setsys:                         * Systemeinstellungen in das NVRAM
 cmp.b #$03, uhrausw(a5)
 bne.s setsys10                 * keine Dallas Uhr vorhanden
 movem.l a0/a1, -(a7)
 movea.l a0, a1                 * A0 sichern
 addq.l #2, a0                  * Datenbereich
 bsr nvrsum                     * Kontrollsumme der NVR-Daten
 move d0, (a1)                  * Kontrollsumme in Datenblock
 movea.l a1, a0
 bsr nvrwrite
 clr d0
 movem.l (a7)+, a0/a1
 rts
setsys10:
 move #-1, d0                   * -1 = keine Dallas Uhr
 rts

getsys:                         * Systemeinstellungen aus dem NVRAM
 cmp.b #$03, uhrausw(a5)
 bne.s getsys10                 * keine Dallas Uhr vorhanden
 movem.l a0/a1, -(a7)
 movea.l a0, a1                 * A0 sichern
 bsr nvrread                    * NVRAM lesen
 movea.l a1, a0
 addq.l #2, a0                  * Datenbereich
 bsr nvrsum                     * Kontrollsumme der NVR-Daten
 cmp (a1), d0
 bne.s getsys11                 * Daten nicht gltig
 movem.l (a7)+, a0/a1
 clr d0
 rts
getsys10:
 move #-1, d0                   * -1 = Keine Dallas Uhr
 rts
getsys11:
 move #-2, d0                   * NVRAM Daten ungltig
 movem.l (a7)+, a0/a1
 rts

nvrsum:                         * Kontrollsumme des NVRAMs berechnen
 move.l d3, -(a7)
 move #30-1, d3                 * Anzahl der NVRAM-Bytes -2
 clr.l d0
nvrsum01:
 add.b (a0)+, d0
 dbra d3, nvrsum01
 and.l #$0000FFFF, d0           * nur ein Wort
 move.l (a7)+, d3
 rts

nvrread:                        * lesen des NVRAMs nach a0
 movem.l d2/d3, -(a7)
 move #32-1, d3                 * 32 Byte
 move #$0e, d2                  * ab RTC-Adresse $0E
nvrread1:
 move.b d2, rtcreg.w            * RTC Adresse
 move.b rtcdat.w, (a0)+         * RTC Daten
 addq #1, d2                    * nchste Adresse
 bsr uwait                      * etwas warten
 dbra d3, nvrread1
 movem.l (a7)+, d2/d3
 rts

nvrwrite:                       * schreiben von a0 nach NVRAM
 movem.l d2/d3, -(a7)
 move #32-1, d3                 * 32 Byte
 move #$0e, d2                  * ab RTC-Adresse $0E
nvrw1:
 move.b d2, rtcreg.w            * RTC Adresse
 move.b (a0)+, rtcdat.w         * RTC Daten
 addq #1, d2                    * nchste Adresse
 bsr uwait                      * etwas warten
 dbra d3, nvrw1
 movem.l (a7)+, d2/d3
 rts

initnvrb:                       * NVR-Buffer (a0) initialisieren
 movem.l d3/a0-a2, -(a7)
 movea.l a0, a2
 move #32-1, d3
invrb01:
 clr.b (a0)+
 dbra d3, invrb01
 movea.l a2, a0
 addq.l #2, a0                  * Byte 0 und 1 = Checksumme
 move.b keydil(a5), (a0)+       * DIL; Byte 2
 move.b #0, (a0)+               * Bootdelay; Byte 3
 lea boottab(pc), a1
 move #4-1, d3
invrb02:
 move.b (a1)+, (a0)+            * Autoboot; Byte 4 bis 7
 dbra d3, invrb02
 move.b #$1e, (a0)+             * SER; Byte 8 und 9
 move.b #$0b, (a0)+
 lea s2bd9600(pc), a1
 move #6-1, d3
invrb03:
 move.b (a1)+, (a0)+            * SER2 Kanal A; Byte 10 bis 15
 dbra d3, invrb03
 lea s2bd9600(pc), a1
 move #6-1, d3
invrb04:
 move.b (a1)+, (a0)+            * SER2 Kanal B; Byte 16 bis 21
 dbra d3, invrb04
 movem.l (a7)+, d3/a0-a2
 rts

patch:
 cmp #192, d0                   * max. Trapnummer
 bhi.s patcher
 subq #1, d0                    * auf 0-...
 ble.s patcher                  * <=0? dann Fehler
 movem.l d1/a1, -(a7)           * A0 sichern
 lea traptab, a1
 add d0, d0
 add d0, d0                     * *4 da Langwort-Tabelle
 move.l 0(a1, d0.w), d1         * alten Wert auslesen
 move.l a0, 0(a1, d0.w)         * neuen Wert eintragen
 movea.l d1, a0                 * alter Wert fr Rckgabe
 clr.l d0                       * D0 = 0 fr OK
 movem.l (a7)+, d1/a1
 rts
patcher:
 move.l #-1, d0                 * d0 = -1 als Fehler
 rts

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   b(a5),a1              * allerdings mu Name in d2/d3 vorhanden sein

eintrage:                       * Rev 6.0 a3 wird zestrt
                                * Eintragen eines Namens wenn er nicht existiert
                                * a0 zeigt auf Namen a1 auf Symboltabelle
                                * d3 gibt freien Platz an wird erneuert
 movem.l d0/d1,-(a7)
 bsr.s suchein
 movem.l (a7)+,d0/d1
 tst d2                         * =0 dann war schon da
 beq carset
eint0:
 cmp #1,d2     